# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Have to check each rows, seemed complex but breaked it down.


# Approach
<!-- Describe your approach to solving the problem. -->
Sort events on the basis of their end date.

Create a matrix which will store maximum values that can be achieved till now.

Now iterate over each sorted events :

if an event is found that started before ( previous variable in code ) the current iterating event then check that if its value can be added to current
else add the value of that event or previous row value in matrix, whichever  is greater.

The last element of our created matrix will contain the answer.

Look at the code and still if you have any confusion then please let me know in comments. :)

# Complexity
- Time complexity : $$O(n*(logn)*k)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity: $$O(nk)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int maxValue(int[][] events, int k) {

        Arrays.sort( events, ( int[] e1, int[] e2) -> e1[1] - e2[1]);        //sorting events on the basis of their end date
        int len = events.length;
        int[][] m = new int[len+1][ k+1]; // create a matrix which will store maximum values that can be achieved till now 
        for( int i = 0; i < len; i++){
            int startday = events[i][0], value = events[i][2];
            int previous = findprevious( events, i, startday);               // previous will store any event that start date is before the current event
            for( int j = 1; j <= k; j++){
                m[ i+1][j] = Math.max( value + m[previous][j-1], m[i][j]);   // if a event has started and ended before current event then add that value to the value of current event ; return which is bigger this updated value or the value at previous event
            }
        }
        return m[len][k];
    }

    public int findprevious( int[][] events, int beforethis, int startday){   // binary search to find previous event
        int l = 0, b = beforethis;
        while( l < b){
            int m = ( l + b)/2;
            if( events[m][1] >= startday){
                b = m;
            }
            else{
                l = m + 1;
            }
        }
        return l;
    }
}
```